/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.standard.v2_1.parts;

import com.roguewave.chart.core.v2_1.ChartProperties;
import com.roguewave.chart.core.v2_1.Customizer;
import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.core.v2_1.graphics.Drawable;
import com.roguewave.chart.core.v2_1.graphics.Line3D;
import com.roguewave.chart.core.v2_1.graphics.Line3DDrawable;
import com.roguewave.chart.core.v2_1.graphics.Point3D;
import com.roguewave.chart.core.v2_1.graphics.Transform3D;
import com.roguewave.chart.overlay.core.v2_1.NumericFormatter;
import com.roguewave.chart.standard.v2_1.parts.CompoundDrawable;
import com.roguewave.chart.standard.v2_1.parts.LabelGenerator;
import com.roguewave.chart.standard.v2_1.parts.LabelGenerator2D;
import com.roguewave.chart.standard.v2_1.parts.LabelGenerator3D;
import com.roguewave.chart.standard.v2_1.parts.Scale;
import com.roguewave.chart.standard.v2_1.parts.Spacer;
import java.awt.Color;
import java.awt.Font;
import java.util.Vector;

public class NumericScale
implements Customizer,
Scale {
    private static final double defaultTopOverrunTolerance = 0.25;
    private static Font defaultScaleFont = new Font("TimesRoman", 0, 14);
    Point3D origin_;
    double low_;
    double increment_;
    int alignment_;
    boolean use3DFont_;
    Transform3D trans_;
    String[] leftStrings_ = null;
    Font font_ = defaultScaleFont;

    public NumericScale(double width, double low, double increment, boolean vertical) {
        if (vertical) {
            this.origin_ = new Point3D(-width / (double)2, 0.0, 0.0);
            this.alignment_ = 1;
            this.trans_ = new Transform3D();
        } else {
            this.origin_ = new Point3D(width / (double)2, 0.0, 0.0);
            this.alignment_ = 0;
            this.trans_ = Transform3D.rotateZNeg90Degrees();
        }
        this.low_ = low;
        this.increment_ = increment;
        this.use3DFont_ = false;
    }

    public NumericScale(double width, double low, double increment, double z, boolean use3DFont, boolean vertical) {
        if (vertical) {
            this.origin_ = new Point3D(width / (double)2, 0.0, z);
            this.alignment_ = 2;
            this.trans_ = new Transform3D();
        } else {
            this.origin_ = new Point3D(width / (double)2, 0.0, z);
            this.alignment_ = 0;
            this.trans_ = Transform3D.rotateZNeg90Degrees();
        }
        this.low_ = low;
        this.increment_ = increment;
        this.use3DFont_ = use3DFont;
    }

    public NumericScale(Point3D origin, double low, double increment, int alignment, boolean use3DFont, Transform3D transform) {
        this.origin_ = origin;
        this.low_ = low;
        this.increment_ = increment;
        this.alignment_ = alignment;
        this.use3DFont_ = use3DFont;
        this.trans_ = transform;
    }

    public String[] getStrings() {
        return this.leftStrings_;
    }

    public Font getFont() {
        return this.font_;
    }

    public Drawable getDrawable(ChartProperties properties, DataModel data) {
        LabelGenerator labelGenerator;
        Boolean use3DFont = new Boolean(this.use3DFont_);
        use3DFont = (Boolean)properties.getProperty("True3DLabels", use3DFont);
        Color scaleColor = (Color)properties.getProperty("ScaleColor", Color.black);
        this.font_ = (Font)properties.getProperty("Scale2DFont", this.font_);
        if (use3DFont.booleanValue()) {
            double fontHeight = properties.getProperty("Scale3DFontSize", 0.4);
            labelGenerator = new LabelGenerator3D(fontHeight);
        } else {
            labelGenerator = new LabelGenerator2D(this.font_);
        }
        labelGenerator = (LabelGenerator)properties.getProperty("NumericLabelGenerator", labelGenerator);
        double increment = properties.getProperty("ScaleIncrement", this.increment_);
        Spacer spacer = new Spacer(properties, this.low_, increment);
        int numLabels = spacer.valueCount();
        double top = properties.scaleY(spacer.getValue(numLabels - 1));
        Line3D scaleLine = new Line3D(this.origin_, this.origin_.plus(new Point3D(0.0, top, 0.0)));
        Vector<Drawable> drawables = new Vector<Drawable>();
        drawables.addElement(new Line3DDrawable(scaleLine.transform(this.trans_), scaleColor));
        String[] strings = new String[numLabels];
        double yUnscaled = this.low_;
        for (int i = 0; i < numLabels; ++i) {
            double y = properties.scaleY(spacer.getValue(i));
            NumericFormatter nf = properties.getScale();
            strings[i] = nf != null ? nf.format(yUnscaled) : new Double(yUnscaled).toString();
            Point3D placement = this.trans_.transform(this.origin_.plus(new Point3D(0.0, y, 0.0)));
            drawables.addElement(labelGenerator.getLabel(strings[i], placement, this.alignment_, scaleColor));
            yUnscaled += increment;
        }
        if (this.alignment_ == 1) {
            this.leftStrings_ = strings;
        }
        return new CompoundDrawable(drawables, this.font_);
    }
}

